package gov.va.vinci.dart.db;

import java.util.List;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.DocumentReviewStatus;

public interface DocumentReviewStatusDAO {

	void save(DocumentReviewStatus status);
	DocumentReviewStatus findById(final int documentId, final int reviewerId, final int groupId) throws ObjectNotFoundException;
	DocumentReviewStatus findByGroupId(final int documentId, final int groupId) throws ObjectNotFoundException;
	int countGroupId(final int documentId, final int groupId) throws ObjectNotFoundException;
	List<DocumentReviewStatus> listByReviewerId(final int reviewerId);
}
